clear
set mem 30m
set more off
capture log close
prog drop _all

cd "C:\ER\"
use "C:\ER\er_05_06.dta", clear

log using "work\curncy.log", replace
gen observation=_n
 
gen period=0
replace period=1 if observation<=87 & observation>=16
replace period=2 if observation<=153 & observation>=88
replace period=3 if observation<=216 & observation>=154
replace period=4 if observation<=282 & observation>=217
replace period=5 if observation<=348 & observation>=283
replace period=6 if observation>=349

 
drop if observation<=15
gen obs=_n-1
order date observation obs period

**********************************************************************************
local var "aud usd cad chf cny gbp hkd idr inr jpy krw mxn myr nzd php rub sgd thb twd"
foreach x of local var {
replace p_sdr_`x'=p_sdr_`x'-p_sdr_eur
replace p_xau_`x'=p_xau_`x'-p_xau_eur
gen t1_sdr_`x'=p_sdr_`x'*obs
gen t_sdr_`x'=p_sdr_`x'*(1-exp(-0.00001*obs))
}
  

*****1
reg p_sdr_cny obs p_sdr_usd p_sdr_jpy p_sdr_krw  p_sdr_myr t_sdr_usd t_sdr_jpy t_sdr_krw  t_sdr_myr 

*****2
reg p_sdr_cny obs p_sdr_usd p_sdr_jpy p_sdr_krw  p_sdr_myr t1_sdr_usd t1_sdr_jpy t1_sdr_krw  t1_sdr_myr 


*****3
nl (p_sdr_cny={b_us}*p_sdr_usd+{rho_us}*(1-exp(-{d}*obs))*p_sdr_usd +{b_yen}*p_sdr_jpy+ {rho_yen}*(1-exp(-{d}*obs))*p_sdr_jpy  /**/ +{b_krw}*p_sdr_krw+ {rho_krw}*(1-exp(-{d}*obs))*p_sdr_krw+{b_myr}*p_sdr_myr+ {rho_myr}*(1-exp(-{d}*obs))*p_sdr_myr /**/ +{c1}*obs+{c0}), initial(c0 0  c1 0 b_us 0.982 rho_us -28 b_yen 0 b_krw 0.01 b_myr 0.01 rho_yen 2 rho_krw 4 rho_myr 20 d 0.00001) iterate(1000) 
 

*****4
nl (p_sdr_cny={b_us}*p_sdr_usd-28.9*(1-exp(-{d}*obs))*p_sdr_usd +{b_yen}*p_sdr_jpy+ {rho_yen}*(1-exp(-{d}*obs))*p_sdr_jpy  /**/ +{b_krw}*p_sdr_krw+ {rho_krw}*(1-exp(-{d}*obs))*p_sdr_krw+{b_myr}*p_sdr_myr+ {rho_myr}*(1-exp(-{d}*obs))*p_sdr_myr /**/ +{c1}*obs+{c0}), initial(c0 0  c1 0 b_us 0.982  b_yen 0 b_krw 0.01 b_myr 0.01 rho_yen 2 rho_krw 4 rho_myr 20 d 0.00001) iterate(1000) 
 

log close

